import subprocess
import sys
from codes.dataset_converter import converter
from codes.predictor import predict
import os
import time

#Run the C output file with arguments to generate features
subprocess.call("./codes/a.out ./data")

#The file with the generated features is in data/Test.input
fp = open("./data/Test.input")
feats = fp.readline().strip()
fp.close()

#Get the sequence as well
fp = open("./data/mtx")
seq = fp.readline()
seq = fp.readline().strip()
fp.close()

#Perform sequence to dataset conversion and then predict
predict(converter(seq, feats), sys.argv[1])

#Remove temporary files
os.remove("./data/Test.input")
os.remove("./data/seq.dat.sa")
os.remove("./data/seq.dat.sa2")
os.remove("./data/seq.dat.ss2")

#Done
print("All predictions have been complete")
